﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3				// Use modern global access method and strict wave access
#pragma hide=1

// uncomment to debug
//#define DEBUG

Menu "TracePopup"
	"Remove This Point", /Q, T21_removeBckgrndPoint()
end

// ***
// MAIN

// draw tab21 - remove background
Function disp_Tab21Draw(pwidth,pheight, ptabpos)
	variable pwidth, pheight, ptabpos

	variable tvoffset, dtvoffset = 30
	variable tleft = 20
	
	tvoffset = ptabpos + dtvoffset
	
	PopupMenu popupBckonStack_tab21,pos={pwidth-110,tvoffset},size={100,23},title=""
	PopupMenu popupBckonStack_tab21,mode=1,value="This Layer;Each Layer;All Layers;",disable=1
	
	// remove background

	tvoffset += 0.8*dtvoffset

	PopupMenu popupBckgHow_tab21,pos={tleft,tvoffset},size={125,25},title="Background Points"
	PopupMenu popupBckgHow_tab21,mode=1,value=#"f_BckGridOptions()",disable=1,proc=X_PopMenuProc
	PopupMenu popupBckgHow_tab21, help={"Set points manually. Set points with a grid."}
	
	PopupMenu popupBckgPntColor_tab21 value="*COLORPOP*",pos={tleft+320,tvoffset-2},disable=1,popColor=(65535,0,0),proc=X_PopMenuProc

	// grid points

	tvoffset += 0.8*dtvoffset
	
	SetVariable setvarbckgx_tab21,pos={tleft+80,tvoffset},size={55,25},title="N\Bx",limits={4,40,1},value=_NUM:4, disable=1, proc=X_SetVarProc
	SetVariable setvarbckgy_tab21,pos={tleft+160,tvoffset},size={55,25},title="N\By",limits={4,40,1},value=_NUM:4, disable=1, proc=X_SetVarProc
	SetVariable setvarbckgmargin_tab21,pos={tleft+240,tvoffset},size={85,25},title="margin",limits={0.01,1,0.01},value=_NUM:0.01, disable=1, proc=X_SetVarProc
	SetVariable setvarbckgmargin_tab21, help={"Margins for grid. Fraction of image size."}

	tvoffset += 0.8*dtvoffset
	
	Button buttonsetbckgrnd_tab21,pos={tleft+95,tvoffset},size={50,20},proc=X_ButtonProc,title="Set"
	Button buttonsetbckgrnd_tab21,userdata="start",disable=1
	Button buttoneditbckpoints_tab21,pos={tleft+150,tvoffset},size={40,20},proc=X_ButtonProc,title="Edit",disable=1
	Button buttonclearbckpoints_tab21,pos={tleft+200,tvoffset},size={40,20},proc=X_ButtonProc,title="Clear",disable=1
	Button buttonrestorebckpoints_tab21,pos={tleft+250,tvoffset},size={60,20},proc=X_ButtonProc,title="Restore",disable=1

	tvoffset += dtvoffset
	
	SetVariable setvarplorder_tab21, pos={tleft,tvoffset}, size={110,25}, title="Plane Order"
	SetVariable setvarplorder_tab21, fSize=12, limits={0,4,1},value=_NUM:1, disable=1, proc=X_SetVarProc

	PopupMenu popupBckNegs_tab21,pos={tleft+150,tvoffset},size={100,25},title="Handle (-)?"
	PopupMenu popupBckNegs_tab21,mode=1,value="Offset Lowest to Zero;Allow;Zero Out;",disable=1
	PopupMenu popupBckNegs_tab21,help={"How should the subtraction handle negative values?"}

	tvoffset += 1.2*dtvoffset

	Button buttonRemoveBckg_tab21,pos={pwidth-85,tvoffset-5},size={75,25},proc=X_ButtonProc,title="Remove"
	Button buttonRemoveBckg_tab21,disable=1
 
	return 0
end

// update tab 21
Function disp_updateTab21()

	variable istack = f_IsStack()
	variable hasBGM = f_HasBckgMrkrs()

	// reset mode to manual if no marquee
	if (!f_HasMQ())
		PopupMenu popupBckgHow_tab21, win=$k_fullpanel, userdata=""
		ControlInfo/W=$k_fullpanel popupBckgHow_tab21
		if ((v_value > 3) && (v_value < 9))
			PopupMenu popupBckgHow_tab21, win=$k_fullpanel, mode=1
		endif
	endif
	
	// ** Settings to Remove Background
	
	ControlInfo/W=$k_fullpanel popupBckgHow_tab21
	T21_SetBckgrndHow(v_value)

	if (!waveexists(root:imgT_bckgY))
		Button buttonclearbckpoints_tab21, win=$k_fullpanel, disable=2
	else
		Button buttonclearbckpoints_tab21, win=$k_fullpanel, disable=0
	endif
	SetVariable setvarplorder_tab21, win=$k_fullpanel, disable=0
	Button buttonRemoveBckg_tab21, win=$k_fullpanel, disable=(2*!hasBGM)
	PopupMenu popupBckOnStack_tab21, win=$k_fullpanel, disable=(!istack)
	PopupMenu popupBckgPntColor_tab21, win=$k_fullpanel, disable=0
	
	ControlInfo/W=$k_fullpanel setvarplorder_tab21
	if (v_value == 0)
		Button buttonRemoveBckg_tab21, win=$k_fullpanel, disable=0
	endif
		
	return 0
end

Function T21_SetBckgrndHow(how)
	variable how

	variable hasBGM = f_HasBckgMrkrs()
	variable hasGBGM = f_HasGlobalBckgMrkrs()
	variable hasStoredBckgrnd = f_HasStoredBckgrnd()
	
	switch(how)
		case 1:	// manual
			Button buttonsetbckgrnd_tab21,win=$k_fullpanel,disable=0,title="Set",userdata="start"
			Button buttoneditbckpoints_tab21,win=$k_fullpanel, disable=(2*!hasBGM)
			Button buttonclearbckpoints_tab21, win=$k_fullpanel,disable=(2*!hasBGM)
			Button buttonrestorebckpoints_tab21 win=$k_fullpanel,disable=(2*!hasStoredBckgrnd)
			SetVariable setvarbckgx_tab21, win=$k_fullpanel, disable=1
			SetVariable setvarbckgy_tab21, win=$k_fullpanel, disable=1
			SetVariable setvarbckgmargin_tab21,win=$k_fullpanel, disable=1
			break			
		default:	// grid
			Button buttonsetbckgrnd_tab21,win=$k_fullpanel,disable=0,title="Reset",userdata="start"
			Button buttoneditbckpoints_tab21,win=$k_fullpanel, disable=(2*!hasBGM)
			Button buttonclearbckpoints_tab21, win=$k_fullpanel,disable=0
			Button buttonrestorebckpoints_tab21 win=$k_fullpanel,disable=1
			SetVariable setvarbckgx_tab21, win=$k_fullpanel, disable=0
			SetVariable setvarbckgy_tab21, win=$k_fullpanel, disable=0
			SetVariable setvarbckgmargin_tab21,win=$k_fullpanel, disable=0
			break
	endswitch
	
	return 0
end

// set the location points for the background
Function T21_SetBackgroundPoints()
	
	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string usD, rcwd, rcwdf
	variable how
	variable whi, hasBGM = f_HasBckgMrkrs()
	variable nx, ny, margin, xc, xr, yc, yr
	wave/Z imgT_bckgX, imgT_bckgY
	STRUCT S_MarqueeCoordinates smc
	
	ControlInfo/W=$k_fullPanel popupBckgHow_tab21
	how = v_value
	usD = GetUserData(k_fullPanel,"buttonsetbckgrnd_tab21","")
	SetDataFolder root:
	strswitch(usD)
		case "start":
			switch(how)
				case 1:		// manual
					Button buttonsetbckgrnd_tab21,win=$k_fullpanel,userdata="end",title="End..."
					SetWindow $k_imgDisplay, userdata(draw)="active"
					SetDrawLayer/W=$k_imgDisplay ProgFront
					GraphWaveDraw/W=$k_imgDisplay/L/T/O imgT_bckgY,imgT_bckgX
					ModifyGraph/W=$k_imgDisplay mode=3,marker=8,msize=5,mrkThick=2
					T21_SetBckgPntColor()
					break
				case 2:		// empty
					break
				case 3:		// grid full
					ControlInfo/W=$k_fullpanel setvarbckgx_tab21
					nx = v_value
					ControlInfo/W=$k_fullpanel setvarbckgy_tab21
					ny = v_value
					ControlInfo/W=$k_fullpanel setvarbckgmargin_tab21
					margin = v_value
					make_GridPoints(nx,ny,margin=margin)
					break
				case 4:		// grid boX outside
					ControlInfo/W=$k_fullpanel setvarbckgx_tab21
					nx = v_value
					ControlInfo/W=$k_fullpanel setvarbckgy_tab21
					ny = v_value
					ControlInfo/W=$k_fullpanel setvarbckgmargin_tab21
					margin = v_value
					if (f_HasMQ())
						Sf_GetMQCoordinates(smc)
						xc = (smc.pgright + smc.pgleft)/2
						yc = (smc.pgbottom + smc.pgtop)/2
						xr = (smc.pgright - smc.pgleft)/2
						yr = (smc.pgbottom - smc.pgtop)/2
						make_GridPoints(nx,ny,mode=1,margin=margin,xcenter=xc,ycenter=yc,xr=xr,yr=yr)
					else
						make_GridPoints(nx,ny,margin=margin)
					endif
					break
				case 5:		// grid boX inside
					ControlInfo/W=$k_fullpanel setvarbckgx_tab21
					nx = v_value
					ControlInfo/W=$k_fullpanel setvarbckgy_tab21
					ny = v_value
					ControlInfo/W=$k_fullpanel setvarbckgmargin_tab21
					margin = v_value
					if (f_HasMQ())
						Sf_GetMQCoordinates(smc)
						xc = (smc.pgright + smc.pgleft)/2
						yc = (smc.pgbottom + smc.pgtop)/2
						xr = (smc.pgright - smc.pgleft)/2
						yr = (smc.pgbottom - smc.pgtop)/2
						make_GridPoints(nx,ny,mode=-1,margin=margin,xcenter=xc,ycenter=yc,xr=xr,yr=yr)
					else
						make_GridPoints(nx,ny,margin=margin)
					endif
					break
				case 6:		// grid Radial outside
					ControlInfo/W=$k_fullpanel setvarbckgx_tab21
					nx = v_value
					ControlInfo/W=$k_fullpanel setvarbckgy_tab21
					ny = v_value
					ControlInfo/W=$k_fullpanel setvarbckgmargin_tab21
					margin = v_value
					if (f_HasMQ())
						Sf_GetMQCoordinates(smc)
						xc = (smc.pgright + smc.pgleft)/2
						yc = (smc.pgbottom + smc.pgtop)/2
						xr = (smc.pgright - smc.pgleft)/2
						yr = (smc.pgbottom - smc.pgtop)/2
						make_GridPoints(nx,ny,mode=2,margin=margin,xcenter=xc,ycenter=yc,xr=xr,yr=yr)
					else
						make_GridPoints(nx,ny,margin=margin)
					endif
					break
				case 7:		// grid Radial inside
					ControlInfo/W=$k_fullpanel setvarbckgx_tab21
					nx = v_value
					ControlInfo/W=$k_fullpanel setvarbckgy_tab21
					ny = v_value
					ControlInfo/W=$k_fullpanel setvarbckgmargin_tab21
					margin = v_value
					if (f_HasMQ())
						Sf_GetMQCoordinates(smc)
						xc = (smc.pgright + smc.pgleft)/2
						yc = (smc.pgbottom + smc.pgtop)/2
						xr = abs(smc.pgright - xc)
						yr = abs(smc.pgtop - yc)
						make_GridPoints(nx,ny,mode=-2,margin=margin,xcenter=xc,ycenter=yc,xr=xr,yr=yr)
					else
						make_GridPoints(nx,ny,margin=margin)
					endif
					break
				case 8:		// blank
					break
				case 9:		// grid Threshold
					ControlInfo/W=$k_fullpanel setvarbckgx_tab21
					nx = v_value
					ControlInfo/W=$k_fullpanel setvarbckgy_tab21
					ny = v_value
					ControlInfo/W=$k_fullpanel setvarbckgmargin_tab21
					margin = v_value
					make_GridPoints(nx,ny,mode=3,margin=margin,xcenter=xc,ycenter=yc,xr=xr,yr=yr)
					break
				case 10:		// grid Fill
					ControlInfo/W=$k_fullpanel setvarbckgx_tab21
					nx = v_value
					ControlInfo/W=$k_fullpanel setvarbckgy_tab21
					ny = v_value
					ControlInfo/W=$k_fullpanel setvarbckgmargin_tab21
					margin = v_value
					make_GridPoints(nx,ny,mode=4,margin=margin,xcenter=xc,ycenter=yc,xr=xr,yr=yr)
					break
			endswitch
			DoUpdate/W=$k_imgDisplay
			break
		case "end":
			switch(how)
				case 1:		// manual
					// update image
					DoUpdate/W=$k_imgDisplay
					GraphNormal/W=$k_imgDisplay
					SetDrawLayer/W=$k_imgDisplay UserFront
					SetWindow $k_imgDisplay, userdata(draw)=""
					if (WhichListItem("scalewy",TraceNameList(k_imgDisplay,";",1)) > 0)
						GraphWaveEdit/W=$k_imgDisplay/T=1 scalewy
					endif
					// update panel
					Button buttonsetbckgrnd_tab21,win=$k_fullpanel,userdata="start",title="Set"
					if (validate_BackgroundPoints() < 0)
						Button buttoneditbckpoints_tab21,win=$k_fullpanel, disable=2
						Button buttonclearbckpoints_tab21,win=$k_fullpanel, disable=2
						Button buttonRemoveBckg_tab21, win=$k_fullpanel, disable=2
						return 0
					else
						Button buttoneditbckpoints_tab21,win=$k_fullpanel, disable=0
						Button buttonclearbckpoints_tab21,win=$k_fullpanel, disable=0
						Button buttonRemoveBckg_tab21, win=$k_fullpanel, disable=0
					endif
					break
				default:
					break
			endswitch			

			// put the data points in the working folder and root:
//			DFREF cdf = GetDataFolderDFR()				
			if (WaveExists(imgT_bckgX))
				wave cbx = imgT_bckgX
				wave cby = imgT_bckgY
				rcwd = "root:" + cwdfolder
				SetDataFolder $rcwd
				rcwd += ":imgT_background"
				NewDataFolder/O $rcwd
				SetDataFolder root:
				rcwdf = rcwd + ":imgT_bckgY"
				duplicate/O cby $rcwdf
				rcwdf = rcwd + ":imgT_bckgX"			
				duplicate/O cbx $rcwdf
			endif
//			SetDataFolder cdf
			break
	endswitch

	return 0
end

Static Function validate_BackgroundPoints()

	wave/Z imgT_bckgX, imgT_bckgY
	
	if (DimSize(imgT_bckgX,0) == 0)
		killwaves imgT_bckgX, imgT_bckgY
		return -1
	endif
	variable imgw, imgh
	imgw = f_ImageSize()[1] - 1
	imgh = f_ImageSize()[2] - 1
	
	imgT_bckgX = imgT_bckgX < 0 ? 0 : imgT_bckgX
	imgT_bckgY = imgT_bckgY < 0 ? 0 : imgT_bckgY
	imgT_bckgX = imgT_bckgX > imgw ? imgw : imgT_bckgX
	imgT_bckgY = imgT_bckgY > imgh ? imgh : imgT_bckgY
	
	return 0
end

// clear the location points for the background
Function T21_EditBackgroundPoints()
	
	//wave/SDFR=root imgT_bckgY, imgT_bckgX
	
	SetDrawLayer/W=$k_imgDisplay ProgFront
	GraphWaveEdit/W=$k_imgDisplay/T=1 imgT_bckgY
	Button buttonsetbckgrnd_tab21,win=$k_fullpanel,userdata="end",title="End..."
	Button buttoneditbckpoints_tab21,win=$k_fullpanel, disable=2
	Button buttonclearbckpoints_tab21,win=$k_fullpanel, disable=2
	Button buttonRemoveBckg_tab21, win=$k_fullpanel, disable=2
	SetWindow $k_imgDisplay, userdata(draw)="active"
	
	return 0
end

// clear the location points for the background
Function T21_ClearBackgroundPoints()
	
	RemoveFromGraph/W=$k_imgDisplay/Z imgT_bckgY
	SetDataFolder root:
	killwaves/Z imgT_bckgY, imgT_bckgX
	Button buttoneditbckpoints_tab21,win=$k_fullpanel, disable=2
	Button buttonclearbckpoints_tab21,win=$k_fullpanel, disable=2
	
	return 0
end

// remove background
Function T21_RemoveBackground()
	
	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	string wdf = "root:" + cwdfolder
	string sfile, wfile
	variable cplane = f_PlaneNumber()
	variable sf, ic, vmin //, vmax //, fpmax = 2^64 - 1
	variable bckgexists=0, nimgs, imin=0, po, onplane, negatives
	
	// avoid background removal on a background
	// set existence of background
	if (f_isBackground())
		bckgexists = 1
		sfile = ReplaceString("_bg",cwfile,"")
		wave/SDFR=$wdf simg = $sfile
		wfile = sfile + "_bg"
	else
		wave/SDFR=$wdf simg = $cwfile
		wfile = cwfile + "_bg"
		sfile = cwfile
	endif

	STRUCT S_BackgroundParams sbg
	Sf_GetBackgroundParams(sbg)
	
	po = sbg.plorder
	onplane = sbg.onplane
	negatives = sbg.negatives

	// set up for background removal
	wave/SDFR=$wdf/Z bimg = $wfile
	bckgexists = waveexists(bimg)
	
	// remove the background
	
	DFREF cdf = GetDataFolderDFR()
	SetDataFolder $wdf
	
	// create new background
	if (bckgexists==0)
		MatrixOP/O $wfile = fp64(simg)
		wave wbimg = $wfile
		wbimg = 0
	else
		// assure that we are at 64 bit
		if (f_ImageBitDepth()!=64)
			wave wbimg = $wfile
			Redimension/D wbimg
		endif
	endif
	
	// extract wave to create background
	if (f_isStack())
		nimgs = f_NImagesInStack()
	else
		nimgs = 1
		onplane = 0
	endif
	
	// create the RoI mask
	wave RoIMask = Generate_BckgPoints(simg)
	
	// wave declarations
	wave/SDFR=$wdf wbimg = $wfile

	// remove background
	switch(onplane)
		case 0:		// not a stack
			MatrixOP/O fsbimg = fp64(simg)
			if (po == 0)
				vmin = WaveMin(fsbimg)
				MatrixOP/O fbimg = fsbimg - vmin
			else
				ImageRemoveBackground/P=(po)/O/R=RoIMask fsbimg
				switch(negatives)
					case 1:	// offset
						vmin = wavemin(fsbimg)
						MatrixOP/O fbimg = (fsbimg - vmin)
						break
					case 2:	// allow
						MatrixOP/O fbimg = fsbimg
						break
					case 3:	// zero out
						MatrixOP/O fbimg = fsbimg
						fbimg = fsbimg < 0 ? 0 : fsbimg
						break
				endswitch
			endif
			wbimg = fbimg
			break
		case 1:		// this plane only
			MatrixOP/O fsbimg = fp64(layer(simg,cplane))
			if (po == 0)
				vmin = WaveMin(fsbimg)
				MatrixOP/O fbimg = fsbimg - vmin
			else
				ImageRemoveBackground/O/P=(po)/R=RoIMask fsbimg
				switch(negatives)
					case 1:	// offset
						vmin = wavemin(fsbimg)
						MatrixOP/O fbimg = (fsbimg - vmin)
						break
					case 2:	// allow
						MatrixOP/O fbimg = fsbimg
						break
					case 3:	// zero out
						MatrixOP/O fbimg = fsbimg
						fbimg = fsbimg < 0 ? 0 : fsbimg
						break
				endswitch
			endif
			ImageTransform/D=fbimg/P=(cplane) setPlane, wbimg
			break
		case 2:		// all planes
			for (ic=0;ic<nimgs;ic+=1)
				MatrixOP/O fsbimg = fp64(layer(simg,ic))
				if (po == 0)
					vmin = WaveMin(fsbimg)
					MatrixOP/O fbimg = fsbimg - vmin
				else
					ImageRemoveBackground/O/P=(po)/R=RoIMask fsbimg
					switch(negatives)
						case 1:	// offset
							vmin = wavemin(fsbimg)
							MatrixOP/O fbimg = (fsbimg - vmin)
							break
						case 2:	// allow
							MatrixOP/O fbimg = fsbimg
							break
						case 3:	// zero out
							MatrixOP/O fbimg = fsbimg
							fbimg = fsbimg < 0 ? 0 : fsbimg
							break
					endswitch
				endif
				ImageTransform/D=fbimg/P=(ic) setPlane, wbimg
			endfor
			break
	endswitch
	
	killwaves/Z fbimg, fsbimg, RoIMask
	CopyScales simg wbimg
	
	SetDataFolder pf

	make/N=4/T/O ptxt={"Removed Background","Plane","Plane Order","On Plane Only"}
	make/N=3/D/O pvals={cplane,po,onplane}
	
	SetDataFolder cdf
	
	return 0
end

ThreadSafe Function TS_RemoveBackground(WAVE fbimgSTACK, WAVE RoIMask, variable po, variable ic)

    variable sf
    MatrixOP/FREE fbimg = layer(fbimgSTACK,ic)
    ImageRemoveBackground/O/W/P=(po)/R=RoIMask fbimg
    WaveStats/Q/M=1 fbimg
    sf = 255/(V_max - V_min)
    MatrixOP/O fbimg = fp64(sf*(fbimg - V_min))
    fbimgSTACK[][][ic] = fbimg[p][q]

    return 0
end

// generate an background points wimg
Function/WAVE Generate_BckgPoints(wave wimg)
	
	variable npts, ic
	variable px, py

	duplicate/O wimg mwimg
	wave mwimg
	if (WaveDims(wimg) == 3)
		Redimension/B/U/N=(-1,-1,1) mwimg
	else
		Redimension/B/U mwimg
	endif
	
	wave/SDFR=root: imgT_bckgY, imgT_bckgX
	npts = numpnts(imgT_bckgY)
	mwimg = 64
	for (ic=0;ic<npts;ic+=1)
		px = ScaletoIndex(mwimg,imgT_bckgX[ic],0)
		py = ScaletoIndex(mwimg,imgT_bckgY[ic],1)
		mwimg[px][py] = 1
	endfor
	
	return mwimg
end

// show background in split window
Function T21_ShowBackground()
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwfile
	disp_ShowInSplit(cwfile[4,inf]+"_bg")
	return 0
end

// restore background points
Function T21_RestoreBackgroundPoints()

	DFREF pf = $k_fullpackagefolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	SetDataFolder root:
	
	string bckfolder = "root:" + cwdfolder + ":imgT_background"
	wave/SDFR=$bckfolder/Z iX = imgT_bckgX, iY = imgT_bckgY
	if (!waveexists(ix))
		return 0
	endif
	
	duplicate/O iY imgT_bckgY
	duplicate/O iX imgT_bckgX
	
	wave/Z imgT_bckgX, imgT_bckgY
	if (!WaveExists(imgT_bckgX))
		return 0
	endif
	
	RemoveFromGraph/Z/W=$k_imgDisplay imgT_bckgY
	AppendtoGraph/W=$k_imgDisplay/T imgT_bckgY vs imgT_bckgX
	ModifyGraph/W=$k_imgDisplay mode(imgT_bckgY)=3,marker(imgT_bckgY)=8,msize(imgT_bckgY)=5,mrkThick(imgT_bckgY)=2
	DoUpdate/W=$k_imgDisplay
	if (strlen(TraceInfo(k_imgDisplay,"scalewy",1))!=0)
		GraphWaveEdit/W=$k_imgDisplay/T=1 scalewy
	endif
	GraphNormal/W=$k_imgDisplay
	SetWindow $k_imgDisplay, userdata(draw)=""
	T21_SetBckgPntColor()
	
	return 0
end

Function T21_SetBckgPntColor()

	if (f_HasBckgMrkrs() == 1)
		ControlInfo/W=$k_fullpanel popupBckgPntColor_tab21
		ModifyGraph/W=$k_imgDisplay rgb(imgT_bckgY)=(v_red,v_green,v_blue)
	endif
	return 0
end

// make a set of grid points
Static Function make_GridPoints(numh,numv,[mode,margin,hmargin,vmargin,xcenter,ycenter,xr,yr])
	variable numh, numv, mode, margin, hmargin, vmargin, xcenter, ycenter, xr, yr

	DFREF pf = $k_fullpackagefolder
	SVAR/SDFR=pf cwdfolder, cwfile

	variable xc, yc, ic, iwidth, iheight, px, py, ox, oy
	variable dx, dy, xo, yo, npnts
	variable left, top
	variable rc, rr, excp = 0
	variable xp, yp, tantheta, xryr
	string strthimg, strflimg
	
	numh = numh < 4 ? 4 : numh
	numv = numv < 4 ? 4 : numv
	
	if (ParamIsDefault(mode))
		mode = 1
	endif
	if (ParamIsDefault(margin))
		margin = 0.02
	else
		margin += 0.02
	endif
	if (ParamIsDefault(hmargin))
		hmargin = margin
	else
		hmargin += 0.02
	endif
	if (ParamIsDefault(vmargin))
		vmargin = margin
	else
		vmargin += 0.02
	endif
	
	wave imgsrc = $f_DisplayImageID(3)
	
	iwidth = DimSize(imgsrc,0)
	iheight = DimSize(imgsrc,1)
	left = DimOffset(imgsrc,0)
	top = DimOffset(imgsrc,1)
	
	xo = hmargin*iwidth + left
	yo = vmargin*iheight + top
	
	dx = (1 - 2*hmargin)*iwidth/(numh-1)
	dy = (1 - 2*vmargin)*iheight/(numv-1)
	
	npnts = numh*numv
	
	if (!ParamIsDefault(xr))
		if (ParamIsDefault(xcenter))
			xcenter = iwidth/2
		endif
		excp = 1
	endif
	if (!ParamIsDefault(yr))
		if (ParamIsDefault(ycenter))
			ycenter = iheight/2
		endif
		excp = 1
	endif
	
	SetDataFolder root:
	make/N=(npnts)/D/O imgT_bckgX, imgT_bckgY
	wave imgT_bckgX, imgT_bckgY
	
	ic = 0
	xryr = xr^2*yr^2
	for (xc=0;xc<numh;xc+=1)
		for (yc=0;yc<numv;yc+=1)
			px = xo + xc*dx
			py = yo + yc*dy
			if (excp == 1)
				switch(mode)
					case -1:	// box mode inside
					case 1:	// box mode outside
						ox = (px < (xcenter - xr) || px > (xcenter + xr)) ? 1 : 0
						oy = (py < (ycenter - yr) || py > (ycenter + yr)) ? 1 : 0
						if (mode == 1)
							px = (ox || oy) ? px : NaN
							py = (ox || oy) ? py : NaN
						else
							px = (ox || oy) ? NaN : px
							py = (ox || oy) ? NaN : py
						endif
						break
					case -2:	// radial mode inside
					case 2:	// radial mode outside
						xp = px - xcenter
						yp = py - ycenter
						rr = xp^2 + yp^2
						tantheta = yp/xp
						ox = xryr/(xr^2*tantheta^2 + yr^2)
						oy = (1 - (ox/xr^2))*yr^2
						rc = ox + oy
						if (mode == 2)
							px = rr < rc ? NaN : px
							py = rr < rc ? NaN : py
						else
							px = rr > rc ? NaN : px
							py = rr > rc ? NaN : py
						endif
						break
					case 3:	// threshold mode
						strthimg = "img_" + StringFromList(f_ThresholdExists(),f_LoimgF())
						wave/SDFR=$(f_DisplayImageID(1)) thimg = $strthimg
						npnts = f_PlaneNumber()
						if (f_IsStack())
							MatrixOP/FREE timg = layer(thimg,npnts)
						else
							Duplicate/FREE thimg timg
						endif
						ox = timg[px][py] > 0 ? 1 : 0
						oy = timg[px][py] > 0 ? 1 : 0
						px = (ox || oy) ? NaN : px
						py = (ox || oy) ? NaN : py
						break
					case 4:	// fill mode
						strflimg = "img_" + StringFromList(f_FillExists(),f_LoimgF())
						wave/SDFR=$(f_DisplayImageID(1)) flimg = $strflimg
						npnts = f_PlaneNumber()
						if (f_IsStack())
							MatrixOP/FREE timg = layer(flimg,npnts)
						else
							Duplicate/FREE flimg timg
						endif
						ox = timg[px][py] > 0 ? 1 : 0
						oy = timg[px][py] > 0 ? 1 : 0
						px = (ox || oy) ? NaN : px
						py = (ox || oy) ? NaN : py
						break
				endswitch
			endif
			imgT_bckgX[ic] = px
			imgT_bckgY[ic] = py
			ic += 1
		endfor
	endfor
	
	if (excp == 1)
		WaveTransform zapNaNs imgT_bckgX
		WaveTransform zapNaNs imgT_bckgY
	endif
	
	string bckfolder = "root:" + cwdfolder + ":imgT_background"
	NewDataFolder/O/S $bckfolder
	duplicate/O root:imgT_bckgX $"imgT_bckgX"
	duplicate/O root:imgT_bckgY $"imgT_bckgY"
	SetDataFolder root:
	
	T21_RestoreBackgroundPoints()
	
	return 0
		
end

Function T21_removeBckgrndPoint()

	string rf = "root:"
	wave/SDFR=$rf bx = imgT_bckgX, by = imgT_bckgY
	
	variable vx, vy, pp
	
	GetLastUserMenuInfo
	if (strlen(S_traceName) != 0)
		vx = AxisValFromPixel(S_graphname,"top",V_mouseX)
		vy = AxisValFromPixel(S_graphname,"left",V_mouseY-cbheight)
		
		duplicate/FREE bx bfx, bT
		duplicate/FREE by bfy
		
		bfx = ((bx < vx*(0.95)) || (bx > vx*(1.05))) ? 1 : 0
		bfy = ((by < vy*(0.95)) || (by > vy*(1.05))) ? 1 : 0
		bT = bfx|bfy
		
		FindValue/V=0 bT
		pp = v_value
		bx[pp] = NaN; by[pp] = NaN
		WaveTransform zapNaNs bx
		WaveTransform zapNaNs by
	endif
	
	return 0
end